'use strict';

/* --------------------------------------------------------------
 orders_parcel_tracking.js 2015-08-27
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2015 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * ## Order Tracking Codes Controller
 *
 * @module Controllers/orders_parcel_tracking
 */
gx.controllers.module('orders_parcel_tracking', ['fallback'],

/** @lends module:Controllers/orders_parcel_tracking */

function (data) {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLE DEFINITION
    // ------------------------------------------------------------------------

    var
    /**
     * Module Selector
     *
     * @var {object}
     */
    $this = $(this),


    /**
     * Default Options
     *
     * @type {object}
     */
    defaults = {},


    /**
     * Final Options
     *
     * @var {object}
     */
    options = $.extend(true, {}, defaults, data),


    /**
     * Module Object
     *
     * @type {object}
     */
    module = {};

    // ------------------------------------------------------------------------
    // EVENT HANDLERS
    // ------------------------------------------------------------------------

    var _addTrackingCode = function _addTrackingCode(event) {

        event.stopPropagation();

        var data_set = jse.libs.fallback._data($(this), 'orders_parcel_tracking');
        var tracking_code = $('#parcel_service_tracking_code').val();
        if (tracking_code === '') {
            return false;
        }

        $.ajax({
            'type': 'POST',
            'url': 'request_port.php?module=ParcelServices&action=add_tracking_code',
            'timeout': 30000,
            'dataType': 'json',
            'context': this,
            'data': {

                'tracking_code': tracking_code,
                'service_id': $('#parcel_services_dropdown option:selected').val(),
                'order_id': data_set.order_id,
                'page_token': data_set.page_token
            },
            success: function success(response) {
                $('#tracking_code_wrapper > .frame-content > table').html(response.html);
            }
        });

        return false;
    };

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    /**
     * Init function of the widget
     */
    module.init = function (done) {

        if (options.container === 'tracking_code_wrapper') {
            $this.on('click', '.add_tracking_code', _addTrackingCode);
        }

        done();
    };

    // Return data to widget engine
    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
